#!/bin/bash

# Run a Iptables Check command to verify if a common DOCKER rule exists
# on the host or not. By default kube-proxy uses iptables-legacy which
# uses the iptables backend. If the rule is missing, it implies that
# the host is using a version of iptables (1.8.2) that is using a nftables
# backend (Red Hat 8), and so we need to update iptables configuration to
# use the NFT backend inside the kube-proxy container

/sbin/iptables --wait -C FORWARD -o docker0 -m conntrack --ctstate RELATED,ESTABLISHED -j ACCEPT
RETVAL=$?
if [ $RETVAL -ne 0 ]; then
	update-alternatives --set iptables /usr/sbin/iptables-nft
	update-alternatives --set ip6tables /usr/sbin/ip6tables-nft
fi

echo "KUBE_PROXY_MODE ($KUBE_PROXY_MODE) CLEANUP_ON_START_DISABLED $KUBE_PROXY_NO_CLEANUP_ON_START"

if [ "$KUBE_PROXY_NO_CLEANUP_ON_START" == "false" ]; then
    echo "Performing cleanup"
    if kube-proxy --cleanup "$@"; then
        echo "kube-proxy cleanup succeeded"
    else
        cleanup_fail_code=$?
        echo "kube-proxy cleanup failed with $cleanup_fail_code"
        exit $cleanup_fail_code
    fi
fi

if [ "$KUBE_PROXY_MODE" == "disabled" ]; then
    echo "Sleeping forever...."
    while true; do sleep infinity; done
fi

echo "Actually starting kube-proxy...."
exec kube-proxy "$@"
