#!/bin/sh

echo 'Waiting for the local Kubernetes API Server to be healthy before starting the Kubernetes Controller Manager.'
cert_mount='/ucp-volume-mounts/ucp-node-certs'
until curl --max-time 2 -f --cert "${cert_mount}/cert.pem" --key "${cert_mount}/key.pem" --cacert "${cert_mount}/ca.pem" https://proxy.local:6444/healthz
do
	echo '...'
	sleep 5
done
echo 'Local Kubernetes API Server appears healthy. Starting Kubernetes Controller Manager...'

( socat tcp-listen:$KUBE_CONTROLLER_MANAGER_METRICS_PROXY_PORT,reuseaddr,fork tcp:localhost:10257 & )

exec kube-controller-manager "$@"
