#!/bin/sh -e

cat << \EOF > /node_targets/node_exporter_targets_tempfile.yml
[
  {
    "labels": {
      "job": "node-exporter"
    },
    "targets": [
      $NODE_TARGETS
    ]
  }
]
EOF

NODE_TARGETS=$(curl -Ss --cacert /node_certs/ca.pem --cert /node_certs/cert.pem --key /node_certs/key.pem $UCP_LIST_NODES_URL \
  | jq --arg jq_node_exporter_port $NODE_EXPORTER_PORT '.[] | select(.Description.Platform.OS == "linux" and .Status.State == "ready" ) | .Status.Addr + ":" + $jq_node_exporter_port' \
  | paste -sd ",")

if [ ! "$NODE_TARGETS" ]; then
  exit 1
fi

sed -e "s#\$NODE_TARGETS#$NODE_TARGETS#g" \
      -i"" /node_targets/node_exporter_targets_tempfile.yml

if [ ! -f "/node_targets/node_exporter_targets.yml" ] || ! cmp -s "/node_targets/node_exporter_targets_tempfile.yml" "/node_targets/node_exporter_targets.yml"; then
  mv /node_targets/node_exporter_targets_tempfile.yml /node_targets/node_exporter_targets.yml
fi
