#!/bin/sh

envsubst '$UCP_URL:$CERT_DIR' < /etc/authorization_config_template.cfg > /ucp-volume-mounts/ucp-kube-apiserver-config/authorization_config.cfg
envsubst '$UCP_URL:$CERT_DIR' < /etc/audit_webhook_template.cfg > /ucp-volume-mounts/ucp-kube-apiserver-config/audit_webhook.cfg

echo 'Waiting for the local etcd server to be healthy before starting the Kubernetes API Server.'
etcd_cert_mount='/ucp-volume-mounts/ucp-kv-certs'
until curl --max-time 2 -f --cert "${etcd_cert_mount}/cert.pem" --key "${etcd_cert_mount}/key.pem" --cacert "${etcd_cert_mount}/ca.pem" https://$UCP_IP_ADDRESS:12379/health
do
	echo '...'
	sleep 5
done
echo 'Local etcd server appears healthy. Starting Kubernetes API Server...'

# The below lines ensure kubectl get cs continues to work
# While the cs command is deprecated by upstream k8s, we
# should support it till it is removed by upstream k8s
#
# Scheduler Healthz
( socat TCP-LISTEN:$KUBE_SCHEDULER_HEALTHZ_PORT,fork TCP:$UCP_IP_ADDRESS:$KUBE_SCHEDULER_HEALTHZ_PORT ) &
# Controller Manager Healthz
( socat TCP-LISTEN:$KUBE_CONTROLLER_MANAGER_HEALTHZ_PORT,fork TCP:$UCP_IP_ADDRESS:$KUBE_CONTROLLER_MANAGER_HEALTHZ_PORT ) &

exec kube-apiserver "$@"
