import os

import pytest
import logging


from sf_notifier.salesforce.client import SalesforceClient, SfNotifierError


ENV_VARS = [
    'SFDC_AUTH_URL',
    'SFDC_USERNAME',
    'SFDC_PASSWORD',
    'SFDC_ORGANIZATION_ID',
    'SFDC_ENVIRONMENT_ID',
    'SFDC_SANDBOX_ENABLED'
]


def unset_env_vars():
    for v in ENV_VARS:
        if os.environ.get(v):
            del os.environ[v]


def test_validate_config():
    OK_CONFIG_1 = [
        {
            'AUTH_URL': 'instance_xxx',
            'USERNAME': 'username_xxx',
            'PASSWORD': 'password_xxx',
            'ORGANIZATION_ID': 'org_xxx',
            'ENVIRONMENT_ID': 'env_xxx',
            'SANDBOX_ENABLED': True
        },
        {
            'instance_url': 'instance_xxx',
            'username': 'username_xxx',
            'password': 'password_xxx',
            'organizationId': 'org_xxx',
            'environment_id': 'env_xxx',
            'domain': 'test'
        }
    ]
    OK_CONFIG_2 = [
        {
            'AUTH_URL': 'instance_xxx',
            'USERNAME': 'username_xxx',
            'PASSWORD': 'password_xxx',
            'ORGANIZATION_ID': 'org_xxx',
            'ENVIRONMENT_ID': 'env_xxx'
        },
        {
            'instance_url': 'instance_xxx',
            'username': 'username_xxx',
            'password': 'password_xxx',
            'organizationId': 'org_xxx',
            'environment_id': 'env_xxx'
        }
    ]
    WRONG_CONFIG = {
        'AUTH_URL': 'xxx',
        'USERNAME': 'xxx',
        'PASSWORD': 'xxx',
        'ORGANIZATION_ID': 'xxx',
        'ENV_ID': 'env_xxx',
        'SANDBOX_ENABLED': True
    }

    unset_env_vars()

    assert SalesforceClient._validate_config(OK_CONFIG_1[0]) == OK_CONFIG_1[1]
    assert SalesforceClient._validate_config(OK_CONFIG_2[0]) == OK_CONFIG_2[1]
    with pytest.raises(SfNotifierError):
        assert SalesforceClient._validate_config(WRONG_CONFIG)
