import os

from ..helpers import is_true, get_env_or_secret


VERSION = 'development'

LOGGING = {
    'version': 1,
    'formatters': {'default': {
        'format': '[%(asctime)s] %(levelname)s in %(module)s: %(message)s',
    }},
    'handlers': {'wsgi': {
        'class': 'logging.StreamHandler',
        'stream': 'ext://flask.logging.wsgi_errors_stream',
        'formatter': 'default'
    }},
    'loggers': {
        logger: {
            'level': os.getenv('LOGGER_LEVEL', 'INFO').upper(),
            'handlers': ['wsgi']
        } for logger in ['sf_notifier.server', 'sf_notifier.salesforce.client']
    }
}

SIMPLE_SETTINGS = {
    'OVERRIDE_BY_ENV': True,
    'CONFIGURE_LOGGING': True,
}

ADD_LINKS = is_true(os.environ.get('SF_NOTIFIER_ADD_LINKS'))
CLUSTER_ID = os.environ.get('SF_NOTIFIER_CLUSTER_ID')

SF_CONFIG = {
    # Salesforce login params
    'AUTH_URL': os.environ.get('SFDC_AUTH_URL', 'null'),
    'USERNAME': get_env_or_secret('SFDC_USERNAME', 'sfdc_username'),
    'PASSWORD': get_env_or_secret('SFDC_PASSWORD', 'sfdc_password'),
    'ORGANIZATION_ID': os.environ.get('SFDC_ORGANIZATION_ID', 'null'),
    'ENVIRONMENT_ID': get_env_or_secret('SFDC_ENVIRONMENT_ID', 'sfdc_environment_id'),
    'SANDBOX_ENABLED': is_true(os.environ.get(
        'SFDC_SANDBOX_ENABLED', 'False')),
    # sf-notifier specific params
    'FEED_ENABLED': is_true(os.environ.get(
        'SF_NOTIFIER_FEED_ENABLED', 'True')),
    'HASH_FUNC': os.environ.get(
        'SF_NOTIFIER_ALERT_ID_HASH_FUNC', 'sha256'),
}
