#!/bin/ash

export SIMPLE_SETTINGS=${SIMPLE_SETTINGS:-sf_notifier.settings.production}

WORKERS=${SF_NOTIFIER_WORKERS:-4}
BUFFER=${SF_NOTIFIER_BUFFER_SIZE:-32768}
PORT=${SF_NOTIFIER_APP_PORT:-5000}

uwsgi -p ${WORKERS} \
    --uid 1000 \
    --gid 1000 \
    --http 0.0.0.0:${PORT} \
    --wsgi-file sf_notifier/server.py \
    --callable app_dispatch \
    --buffer-size=${BUFFER} \
    --max-worker-lifetime 300 \
    --master \
    --req-logger=file:${LOGPATH}
