# sf-notifier

Prometheus Alertmanager webhook receiver sending alert notification to Salesforce.  
The original code base is located at https://gerrit.mcp.mirantis.com/plugins/gitiles/packaging/sources/sf-notifier/+/refs/heads/mcp/xenial/extra  
but was copied to orca tree to reduce maintenance/delivery time of bugs&CVEs fixes.  
The original code base was created by Mirantis Stacklight team. It's recommended for any business logic change to contact Stacklight team if needed.

From time to time it's also recommended to watch the original code base for business logic changes and cherry-pick them.  
It's not expected that there will be many business logic changes, thus currently this tool requires CVE fixes only.  


## Development

### Setup

Install Python dependencies:

```
$ virtualenv venv -p python3
$ source venv/bin/activate
(venv)$ source sf_notifier/vars/development
(venv)$ pip install --upgrade pip
(venv)$ pip install -e .
```

Add to `settings/development.py` credentials for your Salesforce customer (not engineering) account:

```
SF_CONFIG = {
    'AUTH_URL': 'xxx',
    'USERNAME': 'xxx',
    'PASSWORD': 'xxx',
    'ORGANIZATION_ID': 'xxx',
    'ENVIRONMENT_ID': 'xxx',
    'SANDBOX_ENABLED': True
}
```

You may also specify environment variables to override Python settings:

```
export SFDC_AUTH_URL="xxx"
export SFDC_USERNAME="xxx"
export SFDC_PASSWORD="xxx"
export SFDC_ORGANIZATION_ID="xxx"
export SFDC_ENVIRONMENT_ID="xxx"
export SFDC_SANDBOX_ENABLED=true
```

Run server:

```
(venv)$ uwsgi --http 127.0.0.1:5000 --wsgi-file sf_notifier/server.py --callable app_dispatch
```

Check in browser:

```
http://127.0.0.1:5000/metrics
```

### Testing in MKE
Salesforce Notifier service is mostly used by MKE OpsCare+ customers.  
It's highly recommended to test&verify ucp-metrics/Prometheus/Alertmanager/SF-notifier changes using the following procedure:

1. Create testkit cluster: `testkit create -d --ucp --org registry.ci.mirantis.com/mirantiseng --tag 3.7.0-hash --args "--admin-password password" ubuntu_20.04=1 --engine-channel stable --engine-product ee --engine-version 20.10.17 --parallel --name notifier-test`  
Sign it to MKE UI as admin -> admin -> Admin Settings -> Usage
2. Add Salesforce credentials from https://github.com/Mirantis/orca/pull/19495.  
Hit on Create Secrets, then Enable OpsSare and Save
3. ssh to MKE manager node, `docker service logs -f ucp-sf-notifier`  
After 3-4 minutes, the sf-notifier should successfully receive Watchdog alert from alert manager https://github.com/Mirantis/orca/blob/master/images/metrics/alertmanager/prometheus_alert_rules.yml#L4 and test the alert pipeline.  
Successful verification of the sf-pipeline will be reflected in the logs of ucp-sf-notifier service:  
```
ucp-sf-notifier.0.fen1682r684x@notifier-test-ubuntu-0    | [2023-06-17 17:06:23,603] INFO in client: Try to create case: {'Subject': 'Watchdog alert. It is always firing', 'Description': 'This is an alert meant to ensure that the entire alerting pipeline is functional. This alert is always firing, therefore it should always be firing in Alertmanager and always fire against a receiver.', 'IsMosAlert__c': 'true', 'Alert_Priority__c': '060 Informational', 'Alert_Host__c': 'UNKNOWN', 'Alert_Service__c': 'mke', 'Environment2__c': 'a2X6s000000BtLI', 'Alert_ID__c': '9910ff0fe48f478800896dac3c4b780d182d8ca68684d65a4168af1db2fcc156', 'IsWatchDogAlert__c': 'true'}.
ucp-sf-notifier.0.fen1682r684x@notifier-test-ubuntu-0    | [2023-06-17 17:06:36,597] WARNING in client: Duplicate case: duplicate value found: Alert_ID__c duplicates value on record with id: 5006s0000052jmLAAQ.
```
4. Sign in https://mirantis--mkeops.sandbox.my.salesforce.com/.  
For credentials, please create a ticket in Business Apps and Tools JIRA if you haven't received them yet.
In Salesforce search for "watchdog". The case #4785904 should be the one holding the alert for MKE Ops.  
Open the case and in the most recent update the following message should appear:  
```
This is an alert meant to ensure that the entire alerting pipeline is functional. 
This alert is always firing, therefore it should always be firing in Alertmanager and always fire against a receiver.
```
This truly confirms the pipeline works. The next step would be to simulate real-life issue and it's alert.
5. In MKE manager node stop the reconciler:
```
docker node ls
docker node update --label-add com.docker.ucp.agent-pause=true <id of manager node from the previous step>
```
6. Stop ucp-controller container `docker stop ucp-controller`
7. Monitor the logs of ucp-sf-notifier `docker service logs -f ucp-sf-notifier`
8. The expected alert is: `MKE API is down` (typically happens after 4-5 mins) and the corresponding log in sf-notifier should be:  
```
ucp-sf-notifier.0.fen1682r684x@notifier-test-ubuntu-0    | [2023-06-17 17:15:47,210] INFO in client: Try to create case: {'Subject': 'MKE API is down', 'Description': 'The MKE API (port 443) is not accessible for the last 1 minute.', 'IsMosAlert__c': 'true', 'Alert_Priority__c': '090 Critical', 'Alert_Host__c': 'UNKNOWN', 'Alert_Service__c': 'mke', 'Environment2__c': 'a2X6s000000BtLI', 'Alert_ID__c': '57b167ad4f7de7dc3b183c0d50faea89e51add54787403c8fe360f58258421f8'}.
ucp-sf-notifier.0.fen1682r684x@notifier-test-ubuntu-0    | [2023-06-17 17:15:47,979] WARNING in client: Duplicate case: duplicate value found: Alert_ID__c duplicates value on record with id: 5006s000007nwYQAAY.
```
9. In https://mirantis--mkeops.sandbox.my.salesforce.com/ click on Alert Management and look for the subject `MKE API is down`.  
In most cases it's case #4799529, and once the case is opened, the following update should be there: `The MKE API (port 443) is not accessible for the last 1 minute.`
10. Other alerts can be manually tested too, such as `docker stop ucp-swarm-manager` or `ucp-kube-proxy` will trigger alert and the case creation/update `MKE containers are "Unhealthy"`, but typically testing Watchdog and one of the alerts should be enough to confirm pipeline is working.
