#!/bin/bash
#
# Collects info from dead containers using `find-busy-mnt.sh`
#
# Ref: https://github.com/Mirantis/orca/issues/11809

echo ""
echo "Running find-busy-mnt.sh against dead containers"
echo "================================================"
echo ""

smash_no_value() {
    case "$1" in
        "<no value>") my_id="" ;;
        *) my_id=$(echo $1 | rev | cut -f2 -d/ | rev) ;;
    esac

    echo $my_id
}

get_mount_ids() {
    hostname_path=$(docker container inspect --format='{{.HostnamePath}}' $1)
    merged_dir=$(docker container inspect --format='{{.GraphDriver.Data.MergedDir}}' $1)

    shm_id=$(smash_no_value "$hostname_path")
    root_id=$(smash_no_value "$merged_dir")

    echo $shm_id $root_id
}

main() {
c_ids=$(docker container ls -a | egrep "Dead|Removal in progress" | awk '{print $1}')

for c_id in $c_ids ; do
        dfmt_out=$(docker container inspect --format='{{.HostnamePath}} {{.GraphDriver.Data.MergedDir}}' $c_id)
        hostname_path=$(echo $dfmt_out | cut -f1 -d' ')
        merged_dir=$(echo $dfmt_out | cut -f2 -d' ')

        mnt_ids=$(get_mount_ids $c_id)

        echo "--------------------------"
        echo "Container ID: $c_id"
        echo ""

        for id in $(get_mount_ids $c_id) ; do
            echo "Mount ID: $id"
            echo ""
            /bin/find-busy-mnt.sh $id
            echo ""
        done
    done
}

main
