#!/bin/bash

ADDRESS=127.0.0.1
PORT=10248

for i in "$@"; do
  case $i in
    -p=*|--port=*)
      PORT="${i#*=}"
      shift
      ;;
    -a=*|--address=*)
          ADDRESS="${i#*=}"
          shift
          ;;
    -*|--*)
      echo "Unknown option $i"
      exit 1
      ;;
    *)
      ;;
  esac
done

if curl -s "$ADDRESS":"$PORT"/healthz | grep -q "ok"; then
  exit 0
else
  exit 1
fi
