#!/bin/bash

# Run a Iptables Check command to verify if a common DOCKER rule exists
# on the host or not. By default calico-node uses iptables-legacy which
# uses the iptables backend. If the rule is missing, it implies that
# the host is using a version of iptables (1.8.2) that is using a nftables
# backend (Red Hat 8), and so we need to update iptables configuration to
# use the NFT backend inside the calico-node container

COMMAND="$@"
echo "Setting ipt"
/sbin/iptables --wait -C FORWARD -o docker0 -m conntrack --ctstate RELATED,ESTABLISHED -j ACCEPT
RETVAL=$?
if [ $RETVAL -ne 0 ]; then
    echo "Setting alt"
	update-alternatives --set iptables /usr/sbin/iptables-nft
	update-alternatives --set ip6tables /usr/sbin/ip6tables-nft
fi

# Set the Felix environment variable if the host and container are using NFT backends
NF_PRESENT=`iptables --version | grep nf | wc -l`
[ $NF_PRESENT -eq 1 ] && export FELIX_IPTABLESBACKEND=NFT

exec $COMMAND

