#!/bin/sh

# Kill all children if we receive SIGTERM or SIGQUIT
trap "kill 0" QUIT TERM

# Check nginx config. Trigger swarm service rollback if it's no good.
nginx -tc /etc/nginx/nginx.conf
if [ "$?" -ne "0" ]; then
  echo 'nginx config check failed'
  exit 1
fi

# Config is good so start config server
if [ ! -p /out/nginx/pipe ]; then
  mkfifo /out/nginx/pipe
fi
( while true; do
  if [ -d /run/secrets/ ]; then
    tar -cf /out/nginx/pipe /etc/nginx/nginx.conf /run/secrets/
  else
    tar -cf /out/nginx/pipe /etc/nginx/nginx.conf
  fi
done ) &

# Update config hashes
mkdir -p /out/nginx/hash
if [ -d /run/secrets/ ]; then
  sha256sum /etc/nginx/nginx.conf /run/secrets/* > /out/nginx/hash/config.sha256
else
  sha256sum /etc/nginx/nginx.conf > /out/nginx/hash/config.sha256
fi

# Clean up stale nginx.conf on upgrade from older HitlessServiceUpdate
# implementation (Interlock v3.2.0 and earlier)
if [ -e /out/nginx/nginx.conf ]; then
  rm /out/nginx/nginx.conf
fi

# Wait forever (for "while true tar" server)
wait
